figure1 = figure('Color',[1 1 1],'rend','painters','units','centimeters','pos',[0.1 0.1 15 10]);
axes1 = axes('Parent',figure1);
hold(axes1,'on');

% native 
native_data = cell2mat(ad(5,2));
native_bar = bar(1,native_data,0.5);
% native stdev
native_error = cell2mat(ad(5,3));
native_errorbars = errorbar(1,native_data,native_error);

% ensilicated samples
ensilicated_ratio = [cell2mat(ad(2,2));cell2mat(ad(3,2));cell2mat(ad(4,2))];
ratio_barplot = bar(2:4,ensilicated_ratio,0.5);
% ensilicated stdev
ensilicated_ratio_error = [cell2mat(ad(2,3));cell2mat(ad(3,3));cell2mat(ad(4,3))];
ratio_errorbars = errorbar(2:4,ensilicated_ratio,ensilicated_ratio_error);

% frozen ensilicated and released
frozen_comparison =             [cell2mat(lw(1,1)) cell2mat(lw(1,4)); cell2mat(lw(2,1)) cell2mat(lw(2,4));cell2mat(lw(3,1)) cell2mat(lw(3,4));cell2mat(lw(4,1)) cell2mat(lw(4,4)) ];
comparison_barplot = bar(5:8,frozen_comparison,1.5);
% frozen ensilicated and released stdev
frozen_comparison_error=      [cell2mat(lw(1,2)) cell2mat(lw(1,5)); cell2mat(lw(2,2)) cell2mat(lw(2,5));cell2mat(lw(3,2)) cell2mat(lw(3,5));cell2mat(lw(4,2)) cell2mat(lw(4,5)) ];
comparison_errorbars = errorbar(frozen_comparison,frozen_comparison_error);


% styling -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
native_bar.FaceColor =[1 1 1];
% native_bar.FaceColor =[ 0.4902    0.1804    0.5608];
native_errorbars.Color =[0 0 0];
% native_errorbars.Color =[0.7490    0.1804    0.6000];
% 
% 
% ratio_barplot.LineStyle = 'none';
ratio_barplot.FaceColor =[0    0.4471    0.7412];
 ratio_errorbars.LineStyle = 'none';
% ratio_barplot(1).XData = [0.2 0.4 0.6]; 
% ratio_errorbars.XData = [0.2 0.4 0.6]; 
ratio_errorbars.Color = [0 0 0];
% ratio_errorbars.Color = [0.7294    0.8314    0.9569];
% 
% 
% comparison_barplot(1).XData = [0.8 1 1.2 1.4]; 
% comparison_barplot(2).XData = [0.8 1 1.2 1.4]; 
comparison_barplot(2).FaceColor =[ 0    0.8000    0.4000];
comparison_barplot(1).FaceColor =[0    0.4471    0.7412];


comparison_errorbars(1).XData = [5 6 7 8]; 
comparison_errorbars(2).XData = [5 6 7 8]; 
comparison_errorbars(1).LineStyle = 'none'; 
comparison_errorbars(2).LineStyle = 'none';
comparison_errorbars(2).Color = [0 0 0 ];
% comparison_errorbars(2).Color = [0.8 0.91 0.85];
comparison_errorbars(1).Color = [0 0 0];
% comparison_errorbars(1).Color = [0.7294    0.8314    0.9569];
comparison_errorbars(1).XData = comparison_barplot(1).XData-0.15; 
comparison_errorbars(2).XData =  comparison_barplot(2).XData+0.15; 
% 
set([ratio_barplot comparison_barplot(1) comparison_barplot(2) native_bar],'EdgeColor','k');
% set([ratio_errorbars comparison_errorbars],'LineWidth',1);
 set([native_errorbars ratio_errorbars comparison_errorbars(1) comparison_errorbars(2)],'AlignVertexCenters','on');
 
 %line
 section = line([4.5 8.5],[25000 25000]);
section_end_left = line([4.5 4.5],[24500 25000]);
 section_end_right = line([8.5 8.5],[24500 25000]);
 set([section_end_left section_end_right section],'Color',[0 0 0],'LineWidth',1);
 text(4.5,26250,'freeze-thawed');

% legend -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
l1 = legend([comparison_barplot(1) comparison_barplot(2)],{'ensilicated','lyophilised'});
set(l1,'Box','off');
l1.FontSize = 10;
l1.Position(2) = l1.Position(2) +0.05;

% axes -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
axes1.XAxis.LineWidth = 0.5;
axes1.YAxis.LineWidth = 0.5;
axes1.YAxis.Exponent = 0;

ylabel('Enzyme activity (U/mg)');
set(axes1,'XTick',[1 2 3 4 5 6 7 8],'XTickLabel', {'Native','High (1:20)',' Standard (1:50)',' Low (1:100)','1 hour','24 hours','2 months','3 months'});
axes1.XTickLabelRotation = 45;
xlim([0 9]);

% graph setting  -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
set(figure1,'PaperPositionMode','auto');
set(figure1,'PaperSize',[figure1.PaperPosition(3) figure1.PaperPosition(4)]);